//**************************************************************************/
// Copyright (c) 2010 Autodesk, Inc.
// All rights reserved.
// 
// These coded instructions, statements, and computer programs contain
// unpublished proprietary information written by Autodesk, Inc., and are
// protected by Federal copyright law. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without
// the prior written consent of Autodesk, Inc.
//**************************************************************************/

// World-view-projection transformation.
float4x4 gWVPXf : WorldViewProjection < string UIWidget = "None"; >;
float4 gMapColor = {0.0f, 0.0f, 0.0f, 1.0f};
float4 gBGColor = {1.0f, 1.0f, 1.0f, 0.0f};

texture2D gEdgeTexture;
texture2D gSilhouetteTexture;
texture2D gZHaloTexture;
texture2D gScene;
texture2D gSceneAlpha;

bool gUseScene;
bool gUseSceneAlpha;
bool gUseEdge;
bool gUseHalo;
bool gUseSilhouette;

SamplerState  EdgeSampler;
SamplerState  SilhouetteSampler;
SamplerState  ZHaloSampler;
SamplerState  SceneSampler;
SamplerState  SceneAlphaSampler;

struct VS_INPUT
{
    float4 Pos : POSITION;
    float3 UV : TEXCOORD0;
};

// Vertex shader output structure.
struct VS_TO_PS
{
    float4 HPos : SV_POSITION;
    float3 UV : TEXCOORD0;
};

// Vertex shader.
VS_TO_PS VS_NPR(VS_INPUT In)
{
    VS_TO_PS Out;

    // Transform the position from object space to clip space for output.
    Out.HPos = mul(In.Pos, gWVPXf);

    // Pass the texture coordinates unchanged.
    Out.UV = In.UV;

    return Out;
}

// Pixel shader.
float4 PS_NPR(VS_TO_PS In) : SV_TARGET
{
    // Please note that: the lines are black and the background is white.
    float e = gUseEdge ? (1.0f - gEdgeTexture.Sample(EdgeSampler, In.UV).r) : 0.0f;
    float s = gUseSilhouette ? (1.0f - gSilhouetteTexture.Sample(SilhouetteSampler, In.UV).r) : 0.0f;

    float z = gUseHalo ? gZHaloTexture.Sample(ZHaloSampler, In.UV).r : 0.0f;

    // Make sure non haloed areas with bigger silhouettes than edges get the same edge color for the overlapping area as the non overlapping.
    float res = s + e;
    res = min(res, 1.0f);

    res = res * (1.0f - z);

    float4 scene;

    // Either we have an input or the fill is white.
    if (gUseScene)
    {
        scene = gScene.Sample(SceneSampler, In.UV);
    }
    else
    {
        scene = gBGColor;
    }

    if (gUseSceneAlpha)
    {
        scene.a = gSceneAlpha.Sample(SceneAlphaSampler, In.UV).a;
    }

    // 3ds Max need alpha output.
    float4 output = (1.0f - res) * scene + res * gMapColor;

    return output;
}

// The main technique.
fxgroup dx10
{
technique10 Main_dx10
{
    pass p0
    {
        VertexShader = compile vs_4_0 VS_NPR();
		GeometryShader = NULL;
        PixelShader = compile ps_4_0 PS_NPR();
    }
}
}
// The main technique.
fxgroup dx11
{
technique11 Main_dx11
{
    pass p0
    {
        VertexShader = compile vs_5_0 VS_NPR();
		GeometryShader = NULL;
        PixelShader = compile ps_5_0 PS_NPR();
    }
}
}